Attribute VB_Name = "mdOrientAxes"
'       This is a part of the source code for Pro/DESKTOP.
'       Copyright (C) 1999-2002 Parametric Technology Corporation.
'       All rights reserved.


Function OrientAxes(firstGeometric As aGeometric, secondGeometric As aGeometric)

'Convenince Function to rotate about an existing condition so that the two geometries with a direction are aligned

'Check if the entitied are selected and
'if the selected entities belong to GeometricClass

If firstGeometric Is Nothing Then
    MsgBox ("First Geometry not Selected")
    Exit Function
Else
    Dim blnFirstGeometric As Boolean
    blnFirstGeometric = firstGeometric.IsA("Geometric")
End If

If secondGeometric Is Nothing Then
    MsgBox ("Second Edge not Selected")
    Exit Function
Else
    Dim blnSecondGeometric As Boolean
    blnSecondGeometric = secondGeometric.IsA("Geometric")
End If

'Exit if the entities selected do not belong to the geometric class
If (blnFirstGeometric And blnSecondGeometric) Then

    'Get the ProDESKTOP Application object
    GetApplicationObject

    'Get the active part document
    Dim Part As PartDocument
    Set Part = app.GetActiveDoc
    
    'UpdateDependencies method
    If (secondGeometric.IsDependentOn(firstGeometric)) Then
        Set temp = firstGeometric
        Set firstGeometric = secondGeometric
        Set secondGeometric = temp
    End If
    'end UpdateDependencies
    
    'Create an orient axes constraint so that the two geometries are aligned
          
    Dim mc As zOrientGeometry
    Set mc = app.GetClass("OrientGeometry").CreateOrientGeometry2(Part.GetDesign, firstGeometric, secondGeometric, 0.6, "Angle")
    
    Dim ins As aDesignInstance
    Set ins = firstGeometric.GetParent("DesignInstance")
    
    ins.AddMatingCondition mc
    
Else

MsgBox ("ImProper Selection of Entities")

End If

End Function
